/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.reflect;

import com.andavin.reflect.ClassResolver;
import com.andavin.reflect.Reflection;
import com.andavin.reflect.exception.UncheckedNoSuchMethodException;
import com.andavin.util.Logger;
import java.lang.reflect.Method;

public class LegacyClassResolver
implements ClassResolver {
    private static final int DEPTH_ADDITION = 3;
    private final Method stackTraceMethod = LegacyClassResolver.getStackTraceMethod();

    LegacyClassResolver() {
    }

    private static Method getStackTraceMethod() {
        try {
            Method method = Reflection.findMethod(Throwable.class, "getStackTraceElement", Integer.TYPE);
            StackTraceElement element = (StackTraceElement)Reflection.invokeMethod(method, (Object)new Throwable(), 0);
            return LegacyClassResolver.class.getName().equals(element.getClassName()) ? method : null;
        }
        catch (UncheckedNoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public String resolve(int depth) {
        Throwable throwable = new Throwable();
        if (this.stackTraceMethod != null) {
            try {
                return ((StackTraceElement)Reflection.invokeMethod(this.stackTraceMethod, (Object)throwable, depth + 3)).getClassName();
            }
            catch (Exception e) {
                Logger.severe(e, "Failed to get single stack trace element from throwable", new Object[0]);
            }
        }
        StackTraceElement[] trace = throwable.getStackTrace();
        return trace[Math.min(depth + 3, trace.length - 1)].getClassName();
    }
}

